/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wut;

import appeng.api.features.HotkeyAction;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.hotkeys.HotkeyActions;
import appeng.menu.ISubMenu;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.TextConstants;
import de.mari_023.ae2wtlib.hotkeys.Ae2WTLibLocatingService;
import de.mari_023.ae2wtlib.networking.c2s.ServerNetworkManager;
import de.mari_023.ae2wtlib.networking.s2c.UpdateWUTPackage;
import de.mari_023.ae2wtlib.terminal.IUniversalWirelessTerminalItem;
import de.mari_023.ae2wtlib.terminal.WTMenuHost;
import de.mari_023.ae2wtlib.wut.ItemWUT;
import de.mari_023.ae2wtlib.wut.WTDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class WUTHandler {
    public static final Map<String, WTDefinition> wirelessTerminals = new HashMap<String, WTDefinition>();
    public static final List<String> terminalNames = new ArrayList<String>();

    public static String getCurrentTerminal(ItemStack terminal) {
        if (terminal.m_41720_() instanceof ItemWUT) {
            String currentTerminal = terminal.m_41784_().m_128461_("currentTerminal");
            if (wirelessTerminals.containsKey(currentTerminal)) {
                return currentTerminal;
            }
            for (String term : terminalNames) {
                if (!terminal.m_41784_().m_128471_(term)) continue;
                currentTerminal = term;
                terminal.m_41784_().m_128359_("currentTerminal", currentTerminal);
                break;
            }
            return currentTerminal;
        }
        for (Map.Entry<String, WTDefinition> entry : wirelessTerminals.entrySet()) {
            if (!terminal.m_41720_().equals(entry.getValue().item())) continue;
            return entry.getKey();
        }
        return "";
    }

    public static void setCurrentTerminal(Player playerEntity, MenuLocator locator, ItemStack itemStack, String terminal) {
        if (!(itemStack.m_41720_() instanceof ItemWUT)) {
            return;
        }
        if (!WUTHandler.hasTerminal(itemStack, terminal)) {
            return;
        }
        assert (itemStack.m_41783_() != null);
        itemStack.m_41783_().m_128359_("currentTerminal", terminal);
        WUTHandler.updateClientTerminal((ServerPlayer)playerEntity, locator, itemStack.m_41783_());
    }

    public static boolean hasTerminal(ItemStack terminal, String terminalName) {
        if (terminal.m_41619_() || terminal.m_41720_() == null) {
            return false;
        }
        if (terminal.m_41720_() instanceof ItemWUT) {
            if (!terminalNames.contains(terminalName)) {
                return false;
            }
            if (terminal.m_41783_() == null) {
                return false;
            }
            return terminal.m_41783_().m_128471_(terminalName);
        }
        return terminal.m_41720_().equals(wirelessTerminals.get(terminalName).item());
    }

    public static void cycle(Player playerEntity, MenuLocator locator, ItemStack itemStack, boolean isHandlingRightClick) {
        if (itemStack.m_41783_() == null) {
            return;
        }
        String nextTerminal = WUTHandler.getCurrentTerminal(itemStack);
        do {
            int i;
            if (isHandlingRightClick) {
                i = terminalNames.indexOf(nextTerminal) - 1;
                if (i == -1) {
                    i = terminalNames.size() - 1;
                }
            } else {
                i = terminalNames.indexOf(nextTerminal) + 1;
                if (i == terminalNames.size()) {
                    i = 0;
                }
            }
            nextTerminal = terminalNames.get(i);
        } while (!itemStack.m_41783_().m_128471_(nextTerminal));
        itemStack.m_41783_().m_128359_("currentTerminal", nextTerminal);
        WUTHandler.updateClientTerminal((ServerPlayer)playerEntity, locator, itemStack.m_41783_());
    }

    public static void updateClientTerminal(ServerPlayer playerEntity, MenuLocator locator, @Nullable CompoundTag tag) {
        ServerNetworkManager.sendToClient(playerEntity, new UpdateWUTPackage(locator, tag));
    }

    public static boolean open(Player player, MenuLocator locator, boolean returningFromSubmenu) {
        WTMenuHost host = (WTMenuHost)((Object)locator.locate(player, WTMenuHost.class));
        if (host == null) {
            return false;
        }
        ItemStack is = host.getItemStack();
        if (is.m_41783_() == null) {
            return false;
        }
        String currentTerminal = WUTHandler.getCurrentTerminal(is);
        if (!wirelessTerminals.containsKey(currentTerminal)) {
            player.m_5661_((Component)TextConstants.TERMINAL_EMPTY, false);
            return false;
        }
        return wirelessTerminals.get(currentTerminal).containerOpener().tryOpen(player, locator, is, returningFromSubmenu);
    }

    @Nullable
    public static MenuLocator findTerminal(Player player, String terminalName) {
        MenuLocator locator = Platform.findTerminalFromAccessory(player, terminalName);
        if (locator != null) {
            return locator;
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (!WUTHandler.hasTerminal(player.m_150109_().m_8020_(i), terminalName)) continue;
            return MenuLocators.forInventorySlot((int)i);
        }
        return null;
    }

    public static ItemStack getItemStackFromLocator(Player player, MenuLocator locator) {
        ItemStack stack = Platform.getItemStackFromTrinketsLocator(player, locator);
        if (!stack.m_41619_()) {
            return stack;
        }
        ItemMenuHost host = (ItemMenuHost)locator.locate(player, WTMenuHost.class);
        if (host == null) {
            return ItemStack.f_41583_;
        }
        return host.getItemStack();
    }

    public static void addTerminal(String name, ContainerOpener open, WTMenuHostFactory WTMenuHostFactory2, MenuType<?> menuType, IUniversalWirelessTerminalItem item, String hotkeyName) {
        if (terminalNames.contains(name)) {
            return;
        }
        ItemStack wut = new ItemStack((ItemLike)AE2wtlib.UNIVERSAL_TERMINAL);
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(name, true);
        wut.m_41751_(tag);
        HotkeyActions.register((HotkeyAction)new Ae2WTLibLocatingService(name), (String)hotkeyName);
        wirelessTerminals.put(name, new WTDefinition(open, WTMenuHostFactory2, menuType, item, wut));
        terminalNames.add(name);
    }

    public static void addTerminal(String name, ContainerOpener open, WTMenuHostFactory WTMenuHostFactory2, MenuType<?> menuType, IUniversalWirelessTerminalItem item) {
        WUTHandler.addTerminal(name, open, WTMenuHostFactory2, menuType, item, "wireless_" + name + "_terminal");
    }

    public static int getUpgradeCardCount() {
        return terminalNames.size() * 2;
    }

    @FunctionalInterface
    public static interface ContainerOpener {
        public boolean tryOpen(Player var1, MenuLocator var2, ItemStack var3, boolean var4);
    }

    @FunctionalInterface
    public static interface WTMenuHostFactory {
        public WTMenuHost create(Player var1, @Nullable Integer var2, ItemStack var3, BiConsumer<Player, ISubMenu> var4);
    }
}

